;/**************************************************************************//**
; * @file     startup_LPC11Uxx.s
; * @brief    CMSIS Cortex-M0 Core Device Startup File
; *           for the NXP LPC11Uxx Device Series
; * @version  V1.10
; * @date     24. November 2010
; *------- <<< Use Configuration Wizard in Context Menu >>> ------------------
; *
; * @note
; * Copyright (C) 2009-2010 ARM Limited. All rights reserved.
; *
; * @par
; * ARM Limited (ARM) is supplying this software for use with Cortex-M 
; * processor based microcontrollers.  This file can be freely distributed 
; * within development tools that are supporting such ARM based processors. 
; *
; * @par
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *
; ******************************************************************************/


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
                DCD     PIN_INT0_IRQHandler       ; PIN_INT0
				DCD     PIN_INT1_IRQHandler       ; PIN_INT1   
                DCD     PIN_INT2_IRQHandler       ; PIN_INT2                
                DCD     PIN_INT3_IRQHandler       ; PIN_INT3                  
                DCD     PIN_INT4_IRQHandler       ; PIN_INT4                 
                DCD     PIN_INT5_IRQHandler       ; PIN_INT5
                DCD     PIN_INT6_IRQHandler       ; PIN_INT6
                DCD     PIN_INT7_IRQHandler       ; PIN_INT7                
                DCD     GINT0_IRQHandler          ; GINT0               
                DCD     GINT1_IRQHandler          ; GINT1
				DCD     I2C1_IRQHandler           ; I2C1               
                DCD     USART1_4_IRQHandler       ; USART1_4
                DCD     USART2_3_IRQHandler       ; USART2_3
                DCD     SCT0_1_IRQHandler         ; SCT0_1
                DCD     SSP1_IRQHandler           ; SSP1
                DCD     I2C0_IRQHandler           ; I2C0
                DCD     CT16B0_IRQHandler         ; CT16B0
                DCD     CT16B1_IRQHandler         ; CT16B1
                DCD     CT32B0_IRQHandler         ; CT32B0
                DCD     CT32B1_IRQHandler         ; CT32B1
                DCD     SSP0_IRQHandler           ; SSP0
                DCD     USART_IRQHandler          ; USART
                DCD     USB_IRQHandler            ; USB_IRQ
                DCD     USB_FIQHandler            ; USB_FIQ
                DCD     ADC_A_IRQHandler          ; ADC_A
                DCD     RTC_IRQHandler            ; RTC
                DCD     BOD_WDT_IRQHandler        ; BOD_WDT
                DCD     FLASH_IRQHandler          ; FLASH
                DCD     DMA_IRQHandler            ; DMA
                DCD     ADC_B_IRQHandler          ; ADC_B
                DCD     USBWAKEUP_IRQHandler      ; USBWAKEUP


                IF      :LNOT::DEF:NO_CRP
                AREA    |.ARM.__at_0x02FC|, CODE, READONLY
CRP_Key         DCD     0xFFFFFFFF
                ENDIF


                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  SystemInit
                IMPORT  __main
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)                

; now, under COMMON NMI.c and NMI.h, a real NMI handler is created if NMI is enabled 
; for particular peripheral.
;NMI_Handler     PROC
;                EXPORT  NMI_Handler               [WEAK]
;                B       .
;                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP
Reserved_IRQHandler PROC
                EXPORT  Reserved_IRQHandler       [WEAK]
                B       .
                ENDP

Default_Handler PROC
                EXPORT  NMI_Handler               [WEAK]
                EXPORT  PIN_INT0_IRQHandler       [WEAK]
                EXPORT  PIN_INT1_IRQHandler       [WEAK]
                EXPORT  PIN_INT2_IRQHandler       [WEAK]
                EXPORT  PIN_INT3_IRQHandler       [WEAK]
                EXPORT  PIN_INT4_IRQHandler       [WEAK]
                EXPORT  PIN_INT5_IRQHandler       [WEAK]
                EXPORT  PIN_INT6_IRQHandler       [WEAK]
                EXPORT  PIN_INT7_IRQHandler       [WEAK]
                EXPORT  GINT0_IRQHandler          [WEAK]
                EXPORT  GINT1_IRQHandler          [WEAK]
                EXPORT  I2C1_IRQHandler           [WEAK]
                EXPORT  USART1_4_IRQHandler       [WEAK]
                EXPORT  USART2_3_IRQHandler       [WEAK]
                EXPORT  SCT0_1_IRQHandler         [WEAK]
                EXPORT  SSP1_IRQHandler           [WEAK]
                EXPORT  I2C0_IRQHandler           [WEAK]
                EXPORT  CT16B0_IRQHandler         [WEAK]
                EXPORT  CT16B1_IRQHandler         [WEAK]
                EXPORT  CT32B0_IRQHandler         [WEAK]
                EXPORT  CT32B1_IRQHandler         [WEAK]
                EXPORT  SSP0_IRQHandler           [WEAK]
                EXPORT  USART_IRQHandler          [WEAK]
                EXPORT  USB_IRQHandler            [WEAK]
                EXPORT  USB_FIQHandler            [WEAK]
                EXPORT  ADC_A_IRQHandler          [WEAK]
                EXPORT  RTC_IRQHandler            [WEAK]
                EXPORT  BOD_WDT_IRQHandler        [WEAK]
                EXPORT  FLASH_IRQHandler          [WEAK]
                EXPORT  DMA_IRQHandler            [WEAK]
                EXPORT  ADC_B_IRQHandler          [WEAK]
                EXPORT	USBWAKEUP_IRQHandler      [WEAK]

NMI_Handler
PIN_INT0_IRQHandler
PIN_INT1_IRQHandler
PIN_INT2_IRQHandler
PIN_INT3_IRQHandler
PIN_INT4_IRQHandler
PIN_INT5_IRQHandler
PIN_INT6_IRQHandler
PIN_INT7_IRQHandler
GINT0_IRQHandler
GINT1_IRQHandler
I2C1_IRQHandler
USART1_4_IRQHandler
USART2_3_IRQHandler
SCT0_1_IRQHandler
SSP1_IRQHandler
I2C0_IRQHandler
CT16B0_IRQHandler
CT16B1_IRQHandler
CT32B0_IRQHandler
CT32B1_IRQHandler
SSP0_IRQHandler
USART_IRQHandler
USB_IRQHandler
USB_FIQHandler
ADC_A_IRQHandler
RTC_IRQHandler
BOD_WDT_IRQHandler
FLASH_IRQHandler
DMA_IRQHandler
ADC_B_IRQHandler
USBWAKEUP_IRQHandler

                B       .

                ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB
                
                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit
                
                ELSE
                
                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END
